# Instrucciones para agentes AI — api_notas

Propósito: proveer a un agente AI la información específica necesaria para trabajar productivamente en este proyecto PHP pequeño (autenticación básica y utilidades de prueba).

- **Arquitectura (big picture):** proyecto procedural PHP servido desde `htdocs/api_notas` en XAMPP. Conexión a MySQL usando `mysqli` en `db_connect.php`. Puntos principales: endpoints PHP que devuelven JSON, lógica de autenticación en `login.php`, y utilidad para crear usuario de prueba en `register_test_user.php`.

- **Entorno local esperado:** Windows + XAMPP. Base de datos `notas_db` (ver `db_connect.php`), usuario MySQL por defecto `root` sin contraseña (XAMPP). Antes de probar, arrancar Apache y MySQL en XAMPP y verificar la existencia de las tablas `users` y `institutions`.

- **Formato de petición / entrada de datos:** los endpoints esperan datos via `$_POST` (form-urlencoded / multipart), NO JSON en `php://input`. Ejemplo de campos para `login.php`: `username`, `password`, `institution`.

- **Respuestas:** todas devuelven JSON con `Content-Type: application/json; charset=UTF-8`. Los mensajes están en español.

- **Patrones de seguridad y estilo en el código:**
  - Usar siempre sentencias preparadas (`$conn->prepare` + `bind_param`) como en `login.php` y `register_test_user.php`.
  - Las contraseñas se guardan con `password_hash()` y se comprueban con `password_verify()` (ver `login.php`). No almacenar contraseñas en texto plano.

- **Convenciones y trampas específicas del proyecto:**
  - El código usa nombres en español para mensajes y existe una mezcla de nombres de columnas/variables: `institution_id` vs `institucion_id`. Verifica el esquema real de la BD antes de cambiar/insertar datos (ej.: `login.php` espera `institution_id` en `users`, mientras que `register_test_user.php` inserta en `institucion_id`).
  - `db_connect.php` centraliza la conexión; inclúyelo siempre (`include 'db_connect.php'`).

- **Comandos útiles y ejemplos (Windows PowerShell):**
  - Arrancar XAMPP desde la interfaz o servicios de Windows.
  - Crear usuario de prueba abriendo en el navegador: `http://localhost/api_notas/register_test_user.php` (o ejecutar la URL con `Invoke-RestMethod`).
  - Petición de login (PowerShell):
    ```powershell
    Invoke-RestMethod -Uri 'http://localhost/api_notas/login.php' -Method Post -Body @{username='admin'; password='12345678'; institution='NombreInstitucion'}
    ```
  - Alternativa con `curl.exe`:
    ```powershell
    curl -X POST -d "username=admin&password=12345678&institution=NombreInstitucion" "http://localhost/api_notas/login.php"
    ```

- **Archivos clave para revisar:**
  - `db_connect.php` — conexión a MySQL y credenciales por defecto.
  - `login.php` — flujo de autenticación: consulta de `institutions` por nombre, obtención de `institution_id`, búsqueda de usuario por `username`+`institution_id`, verificación de contraseña.
  - `register_test_user.php` — utilidad que inserta un usuario de prueba (útil para pruebas rápidas; revisa el nombre de la columna para `institution_id`).

- **Qué evitar/modificar con cuidado:**
  - No cambiar a lectura de JSON (`php://input`) sin actualizar clientes; el código actual usa `$_POST`.
  - Mantener el uso de sentencias preparadas para prevenir inyección SQL.

Si algo en estas instrucciones está incompleto o quieres que añada fragmentos concretos (por ejemplo: esquema SQL de tablas esperadas, comandos para importar la BD, o ejemplos de pruebas automatizadas), dime qué sección ampliar y lo actualizo.
