<?php
include 'db_connect.php';

header("Content-Type: application/json; charset=UTF-8");

// Leemos el cuerpo de la petición (enviado como JSON desde la app)
$input = json_decode(file_get_contents('php://input'), true);

$grade_id = $input['grade_id'] ?? 0;
$new_value = $input['grade_value'] ?? '';

// --- Validación ---
if ($grade_id == 0) {
    echo json_encode(['status' => 'error', 'message' => 'ID de nota no proporcionado.']);
    exit();
}

// Validar que el valor sea numérico y esté en un rango razonable (ej. 0-20)
if (!is_numeric($new_value) || $new_value < 0 || $new_value > 20) {
    echo json_encode(['status' => 'error', 'message' => 'El valor de la nota debe ser un número entre 0 y 20.']);
    exit();
}

// Formateamos el número para que siempre tenga 2 decimales (ej. 7 -> "7.00")
$formatted_value = number_format((float)$new_value, 2, '.', '');

// --- Actualizar la base de datos ---
$sql = "UPDATE grades SET grade_value = ? WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $formatted_value, $grade_id);

if ($stmt->execute()) {
    // Comprobamos si alguna fila fue realmente actualizada
    if ($stmt->affected_rows > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Nota actualizada con éxito.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'La nota no fue encontrada o ya tenía ese valor.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error al ejecutar la actualización.']);
}

$stmt->close();
$conn->close();
?>