<?php
include 'db_connect.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=UTF-8");

$semester_name = $_GET['semester'] ?? '';

if (empty($semester_name)) {
    echo json_encode([]); // Devuelve vacío si no se especifica semestre
    exit();
}

$sql = "
    SELECT c.name, c.professor, c.description
    FROM courses c
    JOIN semesters s ON c.semester_id = s.id
    WHERE s.name = ?
    ORDER BY c.name
";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    echo json_encode(["status" => "error", "message" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}

$stmt->bind_param("s", $semester_name);
$stmt->execute();
$result = $stmt->get_result();

$courses = [];
while ($row = $result->fetch_assoc()) {
    $courses[] = $row;
}

echo json_encode($courses);

$stmt->close();
$conn->close();
?>