<?php
include 'db_connect.php';

// Muestra todos los errores para facilitar la depuración
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Aseguramos que la respuesta sea JSON
header("Content-Type: application/json; charset=UTF-8");

// Obtenemos el nombre de usuario desde la URL (ej: get_grades.php?username=admin)
$username = $_GET['username'] ?? '';

if (empty($username)) {
    echo json_encode(["status" => "error", "message" => "Falta el nombre de usuario."]);
    exit();
}

// 1. Buscamos el ID del usuario
$sql_user = "SELECT id FROM users WHERE username = ?";
$stmt_user = $conn->prepare($sql_user);
if ($stmt_user === false) {
    echo json_encode(["status" => "error", "message" => "Error al preparar la consulta de usuario: " . $conn->error]);
    exit();
}
$stmt_user->bind_param("s", $username);
$stmt_user->execute();
$result_user = $stmt_user->get_result();

if ($result_user->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Usuario no encontrado."]);
    exit();
}
$user = $result_user->fetch_assoc();
$user_id = $user['id'];
$stmt_user->close();

// 2. Buscamos todas las calificaciones para ese usuario
$sql_grades = "
    SELECT
        c.name AS course_name,
        g.grade_name,
        g.grade_value
    FROM grades g
    JOIN enrollments e ON g.enrollment_id = e.id
    JOIN courses c ON e.course_id = c.id
    WHERE e.user_id = ?
    ORDER BY c.name, g.grade_name
";

$stmt_grades = $conn->prepare($sql_grades);
if ($stmt_grades === false) {
    echo json_encode(["status" => "error", "message" => "Error al preparar la consulta de calificaciones: " . $conn->error]);
    exit();
}
$stmt_grades->bind_param("i", $user_id);
$stmt_grades->execute();
$result_grades = $stmt_grades->get_result();

$grades_by_course = [];
while ($row = $result_grades->fetch_assoc()) {
    $course_name = $row['course_name'];
    if (!isset($grades_by_course[$course_name])) {
        $grades_by_course[$course_name] = [];
    }
    $grades_by_course[$course_name][] = [
        'grade_name' => $row['grade_name'],
        'grade_value' => $row['grade_value']
    ];
}

// Devolvemos el resultado en formato JSON
echo json_encode($grades_by_course);

$stmt_grades->close();
$conn->close();
?>