<?php
include 'db_connect.php';

// Muestra todos los errores para facilitar la depuración
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Aseguramos que la respuesta sea JSON
header("Content-Type: application/json; charset=UTF-8");

// Obtenemos el nombre de usuario desde la URL (ej: get_profile.php?username=admin)
$username = $_GET['username'] ?? '';

if (empty($username)) {
    echo json_encode(["status" => "error", "message" => "Falta el nombre de usuario."]);
    exit();
}

// 1. Buscamos los datos del perfil del usuario
$sql_user = "SELECT username, full_name, email FROM users WHERE username = ?";
$stmt_user = $conn->prepare($sql_user);
if ($stmt_user === false) {
    echo json_encode(["status" => "error", "message" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}
$stmt_user->bind_param("s", $username);
$stmt_user->execute();
$result_user = $stmt_user->get_result();

if ($result_user->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Usuario no encontrado."]);
    exit();
}

// Devolvemos el perfil del usuario en formato JSON
$profile = $result_user->fetch_assoc();
echo json_encode($profile);

$stmt_user->close();
$conn->close();
?>