<?php
include 'db_connect.php';

// Muestra todos los errores para facilitar la depuración
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Aseguramos que la respuesta sea JSON
header("Content-Type: application/json; charset=UTF-8");

// Obtenemos el nombre de usuario desde la URL (ej: get_schedule.php?username=admin)
$username = $_GET['username'] ?? '';

if (empty($username)) {
    echo json_encode(["status" => "error", "message" => "Falta el nombre de usuario."]);
    exit();
}

// 1. Buscamos el ID del usuario
$sql_user = "SELECT id FROM users WHERE username = ?";
$stmt_user = $conn->prepare($sql_user);
if ($stmt_user === false) {
    echo json_encode(["status" => "error", "message" => "Error al preparar la consulta de usuario: " . $conn->error]);
    exit();
}
$stmt_user->bind_param("s", $username);
$stmt_user->execute();
$result_user = $stmt_user->get_result();

if ($result_user->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Usuario no encontrado."]);
    exit();
}
$user = $result_user->fetch_assoc();
$user_id = $user['id'];
$stmt_user->close();

// 2. Buscamos el horario de los cursos en los que el usuario está inscrito
$sql_schedule = "
    SELECT
        s.day_of_week,
        s.start_time,
        s.end_time,
        s.classroom,
        c.name AS course_name
    FROM schedules s
    JOIN courses c ON s.course_id = c.id
    JOIN enrollments e ON c.id = e.course_id
    WHERE e.user_id = ?
    ORDER BY FIELD(s.day_of_week, 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado', 'Domingo'), s.start_time
";

$stmt_schedule = $conn->prepare($sql_schedule);
if ($stmt_schedule === false) {
    echo json_encode(["status" => "error", "message" => "Error al preparar la consulta de horario: " . $conn->error]);
    exit();
}
$stmt_schedule->bind_param("i", $user_id);
$stmt_schedule->execute();
$result_schedule = $stmt_schedule->get_result();

$schedule_by_day = [];
while ($row = $result_schedule->fetch_assoc()) {
    $day = $row['day_of_week'];
    if (!isset($schedule_by_day[$day])) {
        $schedule_by_day[$day] = [];
    }
    $schedule_by_day[$day][] = [
        'course_name' => $row['course_name'],
        'start_time' => date("g:i a", strtotime($row['start_time'])), // Formatear hora a AM/PM
        'end_time' => date("g:i a", strtotime($row['end_time'])),
        'classroom' => $row['classroom']
    ];
}

// Devolvemos el resultado en formato JSON
echo json_encode($schedule_by_day);

$stmt_schedule->close();
$conn->close();
?>