<?php
include 'db_connect.php';header("Content-Type: application/json; charset=UTF-8");

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($username) || empty($password)) {
    echo json_encode(['status' => 'error', 'message' => 'Usuario y contraseña son obligatorios.']);
    exit();
}

$sql = "SELECT password, role FROM users WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    // Verificamos la contraseña hasheada
    if (password_verify($password, $user['password'])) {
        // ¡Contraseña correcta! Devolvemos el rol del usuario.
        echo json_encode([
            'status' => 'success',
            'message' => 'Inicio de sesión exitoso.',
            'role' => $user['role'] // <-- ¡Aquí está la magia!
        ]);
    } else {
        // Contraseña incorrecta
        echo json_encode(['status' => 'error', 'message' => 'Usuario o contraseña incorrectos.']);
    }
} else {
    // Usuario no encontrado
    echo json_encode(['status' => 'error', 'message' => 'Usuario o contraseña incorrectos.']);
}

$stmt->close();
$conn->close();
?>